/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.ui.preferences;

import com.aptana.core.CoreStrings;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.ui.IPropertyDialog;
import com.aptana.ui.PropertyDialogsRegistry;
import com.aptana.ui.util.UIUtils;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.IServerManager;
import com.aptana.webserver.core.IServerType;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.ui.WebServerUIPlugin;
import com.aptana.webserver.ui.preferences.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ListDialog;

public class ServersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ListViewer viewer;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.viewer = new ListViewer(composite, 2052);
        this.viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IServerManager) {
                    inputElement = ((IServerManager)inputElement).getServers();
                }
                return super.getElements(inputElement);
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IServer) {
                    return ((IServer)element).getName();
                }
                return super.getText(element);
            }
        });
        this.viewer.setInput((Object)WebServerCorePlugin.getDefault().getServerManager());
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        buttonContainer.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        Button newButton = new Button(buttonContainer, 8);
        newButton.setText(StringUtil.ellipsify((String)CoreStrings.NEW));
        newButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).hint(Math.max(newButton.computeSize((int)-1, (int)-1, (boolean)true).x, this.convertHorizontalDLUsToPixels(61)), -1).create());
        final Button editButton = new Button(buttonContainer, 8);
        editButton.setText(StringUtil.ellipsify((String)CoreStrings.EDIT));
        editButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
        final Button deleteButton = new Button(buttonContainer, 8);
        deleteButton.setText(CoreStrings.DELETE);
        deleteButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).create());
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object[] result;
                ListDialog dlg = new ListDialog(ServersPreferencePage.this.getShell());
                dlg.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                dlg.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return null;
                    }

                    public String getText(Object element) {
                        if (element instanceof IServerType) {
                            return ((IServerType)element).getName();
                        }
                        return super.getText(element);
                    }
                });
                dlg.setInput((Object)WebServerCorePlugin.getDefault().getServerManager().getServerTypes());
                dlg.setTitle(Messages.ServersPreferencePage_Title);
                if (dlg.open() == 0 && (result = dlg.getResult()) != null && result.length == 1) {
                    String typeId = ((IServerType)result[0]).getId();
                    try {
                        IServer newConfiguration = WebServerCorePlugin.getDefault().getServerManager().createServer(typeId);
                        if (newConfiguration != null && ServersPreferencePage.this.editServerConfiguration(newConfiguration)) {
                            WebServerCorePlugin.getDefault().getServerManager().add(newConfiguration);
                            ServersPreferencePage.this.viewer.refresh();
                        }
                    }
                    catch (CoreException e) {
                        IdeLog.logError((Plugin)WebServerUIPlugin.getDefault(), (Throwable)e);
                    }
                }
            }
        });
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IServer selection = (IServer)((IStructuredSelection)ServersPreferencePage.this.viewer.getSelection()).getFirstElement();
                if (selection != null && ServersPreferencePage.this.editServerConfiguration(selection)) {
                    ServersPreferencePage.this.viewer.refresh();
                }
            }
        });
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IServer selection = (IServer)((IStructuredSelection)ServersPreferencePage.this.viewer.getSelection()).getFirstElement();
                if (selection != null && MessageDialog.openQuestion((Shell)ServersPreferencePage.this.getShell(), (String)Messages.ServersPreferencePage_DeletePrompt_Title, (String)Messages.ServersPreferencePage_DeletePrompt_Message)) {
                    WebServerCorePlugin.getDefault().getServerManager().remove(selection);
                    ServersPreferencePage.this.viewer.refresh();
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IServer selection = (IServer)((IStructuredSelection)ServersPreferencePage.this.viewer.getSelection()).getFirstElement();
                if (selection != null && ServersPreferencePage.this.editServerConfiguration(selection)) {
                    ServersPreferencePage.this.viewer.refresh();
                }
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean hasSelection = !event.getSelection().isEmpty();
                editButton.setEnabled(hasSelection);
                deleteButton.setEnabled(hasSelection);
            }
        });
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        return composite;
    }

    private boolean editServerConfiguration(IServer serverConfiguration) {
        try {
            Dialog dlg = PropertyDialogsRegistry.getInstance().createPropertyDialog((Object)serverConfiguration, (IShellProvider)new SameShellProvider((Control)this.getShell()));
            if (dlg != null) {
                if (dlg instanceof IPropertyDialog) {
                    ((IPropertyDialog)dlg).setPropertySource((Object)serverConfiguration);
                }
                return dlg.open() == 0;
            }
        }
        catch (CoreException e) {
            UIUtils.showErrorMessage((String)"Failed to open server preferences dialog", (Throwable)e);
        }
        return false;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(WebServerUIPlugin.getDefault().getPreferenceStore());
    }
}

